import pandas as pd  
import matplotlib.pyplot as plt  
import seaborn as sns  
from decision_company import read_csv_file, create_subplots, df_copy, cast_to_a_dtype, categoricalIndex, categorical_codes, scatter_fig_instance, set_plot_split_title, set_layout, show_plots, save_plot, fetch_column

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Convert 'class' column to binary values  
credit_customers['class_binary'] = fetch_column(credit_customers, 'class').apply(lambda x: 1 if x == 'good' else 0)  
  
# Create a new DataFrame with numerical values for credit_history and employment  
credit_customers_numerical = df_copy(credit_customers)  
credit_customers_numerical['credit_history'] = categorical_codes(categoricalIndex(cast_to_a_dtype(fetch_column(credit_customers_numerical, 'credit_history'), 'category')))
credit_customers_numerical['employment'] = categorical_codes(categoricalIndex(cast_to_a_dtype(fetch_column(credit_customers_numerical, 'employment'), 'category')))  
  
# Plot scatter plots  
fig, axes = create_subplots(2, 2, figsize=(12, 8))  
  
scatter_fig_instance(credit_customers_numerical, 'credit_history', 'class_binary', axes[0, 0])  
set_plot_split_title(axes[0, 0], 'Loan Approval Rates vs. Credit History')  
  
scatter_fig_instance(credit_customers_numerical, 'employment', 'class_binary', axes[0, 1])  
set_plot_split_title(axes[0, 1], 'Loan Approval Rates vs. Employment Status')  
  
scatter_fig_instance(credit_customers_numerical, 'age', 'class_binary', axes[1, 0])  
set_plot_split_title(axes[1, 0], 'Loan Approval Rates vs. Age')  
  
scatter_fig_instance(credit_customers_numerical, 'credit_amount', 'class_binary', axes[1, 1])  
set_plot_split_title(axes[1, 1], 'Loan Approval Rates vs. Credit Amount')  
  
set_layout()  
save_plot('ref_result/scatterplot.png')  
show_plots()  
